%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculation of the thermal conductivity of a two phase system           %
% Nelson Molina-Giraldo 2011                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear; clc;
test = 1;
while any(test) % Test input
   prompt = {'arithmetic mean  = 1, harmonic mean  = 2, geometric mean = 3, Method:'};
   dlg_title = 'Thermal conductivity:';
   num_lines= 1;
   def     = {'1'};
   geometrie  = inputdlg(prompt,dlg_title,num_lines,def);
   fAS = str2num(geometrie{1}); fASTrue = isempty(fAS);
   test = fASTrue;
end

% Input Parameters
test = 1;
while any(test) % Test numerical input
    prompt = {'thermal conductivity of water [W m-1 K-1]','thermal conductivity of solids [W m-1 K-1]','Porosity [-]:'};
    dlg_title = 'Input Parameters';
    num_lines = 1;
    def     = {'0.58','3.5','0.30'};
    transportparameter  = inputdlg(prompt,dlg_title,num_lines,def);
    lw = str2num(transportparameter{1}); lwTrue = isempty(lw);
    ls = str2num(transportparameter{2}); lsTrue = isempty(ls); 
    n = str2num(transportparameter{3}); nTrue = isempty(n);
    test = [lwTrue; lsTrue; nTrue];
end 

% Call function
if  fAS == 1
    lm = Tcond_arithmetic(ls,lw,n);   % arithmetic mean 
elseif fAS == 2
    lm = Tcond_harmonic(ls,lw,n);       % harmonic mean
elseif fAS == 3
    lm = Tcond_geometric(ls,lw,n);     % geometric mean
end

%% Output
fprintf('Bulk thermal conductivity = %0.2f m \n',lm)

